import json
import pickle 
import pandas as pd
import numpy as np

context_dict_path="/mnt/122a7683-fa4b-45dd-9f13-b18cc4f4a187/entity_training/all_contexts_humans_mapped_all_contexts.pkl"
fp_dict="/mnt/122a7683-fa4b-45dd-9f13-b18cc4f4a187/entity_training/formatted_first_para_data_qid_template_people_with_qrank_3occupations.json"

with open(context_dict_path, "rb") as f:
    context_dict = pickle.load(f)

with open(fp_dict, "r") as f:
    fp_dict = json.load(f)
    
##Add 'median_year' to each context of the context list of each entity if it is in fp_dict
for entity in context_dict:
    if entity in fp_dict:
        for context in context_dict[entity]:
            if 'median_year' in fp_dict[entity]:
                ##Add median_year to the context
                context['median_year'] = fp_dict[entity]['median_year']
            if 'qrank' in fp_dict[entity]:
                ##Add qrank to the context
                context['qrank'] = fp_dict[entity]['qrank']
    


                
                
##Save
with open("/mnt/122a7683-fa4b-45dd-9f13-b18cc4f4a187/entity_training/all_contexts_humans_mapped_all_contexts_with_median_year.pkl", "wb") as f:
    pickle.dump(context_dict, f)
