theory question_56_10
```
imports Main

begin

typedecl entity
typedecl event

consts
  Gravity :: "entity ⇒ bool"
  Mass :: "entity ⇒ bool"
  Rocks :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Planet :: "entity ⇒ bool"
  Force :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Movement :: "event ⇒ bool"
  Direction :: "event ⇒ entity ⇒ bool"
  Down :: "entity ⇒ bool"
  PlanetCenter :: "entity ⇒ bool"
  Aligned :: "entity ⇒ entity ⇒ bool"
  Downhill :: "event ⇒ bool"

(* Explanation 1: The force of gravity, Gravity, affects objects with mass, such as rocks, causing them to move towards a planet's center. *)
axiomatization where
  explanation_1: "∀x y e. Gravity x ∧ Mass y ⟶ (∃e. Force e ∧ Agent e x ∧ Patient e y ∧ Movement e ∧ Direction e PlanetCenter)"

(* Explanation 2: A rock is a kind of object that has mass. *)
axiomatization where
  explanation_2: "∀x. Rocks x ⟶ Object x ∧ Mass x"

(* Explanation 3: Gravity is the force that acts on objects with mass on a planet, causing them to move towards the planet's center. *)
axiomatization where
  explanation_3: "∀x y z. Gravity x ∧ Object y ∧ Mass y ∧ Planet z ⟶ (∃e. Force e ∧ Agent e x ∧ Patient e y ∧ Movement e ∧ Direction e PlanetCenter)"

(* Explanation 4: The direction of down is aligned with the direction toward the planet's center, and moving downhill means moving in that direction. *)
axiomatization where
  explanation_4: "∀x y. Down x ∧ PlanetCenter y ⟶ Aligned x y ∧ (∃z. Downhill z ⟶ Movement z ∧ Direction z x)"

(* Explanation 5: When moving downhill, gravity causes rocks to move towards the planet's center. *)
axiomatization where
  explanation_5: "∀x y z. Downhill x ∧ Rocks y ∧ Gravity z ⟶ (∃e. Movement e ∧ Agent e z ∧ Patient e y ∧ Direction e PlanetCenter)"

theorem hypothesis:
  assumes asm: "Gravity g ∧ Rocks r ∧ Downhill d 