theory question_23_9

imports Main

begin

typedecl entity

consts
  Hurricanes :: "entity ⇒ bool"
  HighWinds :: "entity ⇒ bool"
  Tornadoes :: "entity ⇒ bool"

(* Explanation 1: High wind speeds are a direct characteristic of hurricanes. *)
axiomatization where
  explanation_1: "∀x. Hurricanes x ⟶ HighWinds x"

(* Explanation 2: High wind speeds are a direct characteristic of tornadoes. *)
axiomatization where
  explanation_2: "∀x. Tornadoes x ⟶ HighWinds x"

(* Explanation 3: A weather phenomenon that is a hurricane or a tornado always has high wind speeds as a direct characteristic. *)
axiomatization where
  explanation_3: "∀x. (Hurricanes x ∨ Tornadoes x) ⟶ HighWinds x"

theorem hypothesis:
  assumes asm: " Hurricanes x ∨ Tornadoes y "
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "∃x y.  Hurricanes x ∨ Tornadoes y  ∧ HighWinds x ∧ HighWinds y"
proof -
  from asm obtain x where x: "Hurricanes x" by (cases asm)
  then have "HighWinds x" using explanation_1 by simp
  from asm obtain y where y: "Tornadoes y" by (cases asm)
  then have "HighWinds y" using explanation_2 by simp
  show ?thesis using x y by simp
qed

end
