theory question_23_7

imports Main

begin

typedecl entity
typedecl event

consts
  Hurricane :: "event ⇒ bool"
  HighWinds :: "event ⇒ bool"
  Tornado :: "event ⇒ bool"

(* Explanation 1: High wind speeds are a direct characteristic of hurricanes. *)
axiomatization where
  explanation_1: "∀e. Hurricane e ⟶ HighWinds e"

(* Explanation 2: High wind speeds are a direct characteristic of tornadoes. *)
axiomatization where
  explanation_2: "∀e. Tornado e ⟶ HighWinds e"

theorem hypothesis:
  assumes asm: " Hurricane e ∨ Tornado e "
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "∃e.  Hurricane e ∨ Tornado e  ∧ HighWinds e"
proof -
  assume asm
  then have "Hurricane e ⟶ HighWinds e" using explanation_1 by blast
  then have "Tornado e ⟶ HighWinds e" using explanation_2 by blast
  then have "Hurricane e ∨ Tornado e ⟶ HighWinds e" by blast
  then have "∃e. Hurricane e ∨ Tornado e ∧ HighWinds e" using asm by blast
qed

end
