theory question_87_1

imports Main

begin

typedecl entity
typedecl event

consts
  Tunicate :: "entity ⇒ bool"
  Bulbs :: "entity ⇒ bool"
  SexualReproduction :: "entity ⇒ bool"
  Reproduce :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Tunicates, which include bulbs if they are classified as such, reproduce sexually. *)
axiomatization where
  explanation_1: "∀x. Tunicate x ∧ (Bulbs x ∨ ¬Bulbs x) ⟶ (∃y e. SexualReproduction y ∧ Reproduce e ∧ Agent e x ∧ Patient e y)"

(* Explanation 2: Bulbs can be classified as tunicates or non-tunicates. *)
axiomatization where
  explanation_2: "∀x. Bulbs x ⟶ (Tunicate x ∨ ¬Tunicate x)"

theorem hypothesis:
  assumes asm: "Bulbs x"
  (* Hypothesis: Bulbs reproduce sexually. *)
  shows "∃y e. SexualReproduction y ∧ Reproduce e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Bulbs x" by simp
  then have "Tunicate x ∨ ¬Tunicate x" using explanation_2 by blast
  then assume "Tunicate x"
  then have "∃y e. SexualReproduction y ∧ Reproduce e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then show ?thesis by simp
qed

end
