theory question_79_7
imports Main

begin

typedecl entity

consts
  Animal :: "entity ⇒ bool"
  Heterotroph :: "entity ⇒ bool"
  DerivesEnergy :: "entity ⇒ bool"
  Breakdown :: "entity ⇒ bool"

(* Explanation: For all entities x, if an entity x is an animal, then it is a heterotroph. *)
axiomatization where
  explanation: "∀x. Animal x ⟶ Heterotroph x"

theorem hypothesis:
  assumes asm: "Animal x"
  (* Hypothesis: For all entities x, if an entity x is an animal, then it derives energy from the breakdown of organic molecules. *)
  shows "DerivesEnergy x ∧  ∃e. Agent e x ∧ Breakdown e"
proof -
  from asm have "Heterotroph x" using explanation by blast
  then have "DerivesEnergy x" by simp
  then have "DerivesEnergy x ∧ ∃e. Agent e x ∧ Breakdown e" by (rule exI[of _ "energy\_derivation x"])
qed

end
