theory question_63_0

imports Main

begin

typedecl entity
consts
  Rocks :: "entity ⇒ bool"
  FormedByDeposition :: "entity ⇒ bool"
  Formed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Sandstone :: "entity ⇒ bool"

(* Explanation: Rocks are formed by deposition. *)
axiomatization where
  explanation: "∀x e. Rocks x ∧ FormedByDeposition x ∧ Formed e ∧ Agent e x ⟶ (∃y. Sandstone y ∧ Patient e y)"

theorem hypothesis:
  assumes asm: "Rocks x ∧ FormedByDeposition x"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "Sandstone x"
proof -
  from asm have "Rocks x ∧ FormedByDeposition x" by simp
  then obtain e where e: "Formed e ∧ Agent e x" using explanation by blast
  then have "∃y. Sandstone y ∧ Patient e y" by blast
  then obtain y where y: "Sandstone y ∧ Patient e y" by fastforce
  have "Patient e x" using e by simp
  have "x = y" using y by simp
  have conclusion: "Sandstone x" using y by simp
  show ?thesis using asm conclusion by blast
qed

end
