theory question_47_8
imports Main

begin

typedecl entity
typedecl event

consts
  Genes :: "entity ⇒ bool"
  LocatedOnSameChromosome :: "entity ⇒ entity ⇒ bool"
  LinkedGenes :: "entity ⇒ bool"
  InheritedTogether :: "entity ⇒ entity ⇒ entity ⇒ bool"

(* Explanation 1: Genes that are located on the same chromosome, called linked genes, are inherited together. *)
axiomatization where
  explanation_1: "∀x y e. Genes x ∧ Genes y ∧ LocatedOnSameChromosome x y ⟶ (∃z. LinkedGenes z ∧ InheritedTogether z x y)"

theorem hypothesis:
  assumes asm: "Genes x ∧ Genes y ∧ LocatedOnSameChromosome x y"
  (* Hypothesis: Genes are inherited together if they are located on the same chromosome. *)
  shows "∃e. InheritedTogether e x y"
proof -
  from asm have "Genes x" and "Genes y" and "LocatedOnSameChromosome x y" by simp
  then have "LinkedGenes z" and "InheritedTogether z x y" for some z using explanation_1 by blast
  then have "InheritedTogether e x y" for some e using that by (metis InheritedTogether.rep_eq)
  then show ?thesis by simp
qed

end
