theory question_47_0
imports Main

begin

typedecl entity
typedecl event

consts
  Genes :: "entity ⇒ bool"
  SameChromosome :: "entity ⇒ entity ⇒ bool"
  InheritedTogether :: "event ⇒ entity ⇒ entity ⇒ bool"

theorem hypothesis:
  assumes asm: "Genes x ∧ Genes y ∧ SameChromosome x y"
  (* Hypothesis: Genes are inherited together if they are located on the same chromosome. *)
  shows "∃e. InheritedTogether e x y"
proof -
  from asm have "Genes x ∧ Genes y ∧ SameChromosome x y" by simp
  then have "linked x y" using explanation_1 by blast
  then have "InheritedTogether e x y" using explanation_2 by blast
  then show ?thesis using asm `e` by blast
qed

end
