theory question_4_0
imports Main

begin

typedecl entity
typedecl event

consts
  Amphibians :: "entity ⇒ bool"
  Tetrapods :: "entity ⇒ bool"
  Vertebrates :: "entity ⇒ bool"
  FourLimbs :: "entity ⇒ bool"
  Ancathostega :: "entity ⇒ bool"
  EarliestTetrapods :: "entity ⇒ bool"
  Found :: "entity ⇒ bool"
  MostComplete :: "entity ⇒ bool"

(* Explanation 1: Amphibians are the first true tetrapods, or vertebrates with four limbs. *)
axiomatization where
  explanation_1: "∀x. Amphibians x ⟶ (∃y. Tetrapods y ∧ Vertebrates y ∧ FourLimbs y)"

(* Explanation 2: Ancathostega is one of the earliest tetrapods found, and by far the most complete. *)
axiomatization where
  explanation_2: "∃x. Ancathostega x ∧ EarliestTetrapods x ∧ (∀y. EarliestTetrapods y ⟶ Found y) ∧ MostComplete x"

theorem hypothesis:
  assumes asm: "Ancathostega x"
  (* Hypothesis: Ancathostega have four limbs. *)
  shows "FourLimbs x"
proof -
  from asm have "Ancathostega x" by simp
  then have "EarliestTetrapods x" using explanation_2 by blast
  then have "Tetrapods y ∧ Vertebrates y ∧ FourLimbs y" for some y using explanation_1 by blast
  then have "FourLimbs x" using asm by metis
qed

end
