theory question_17_10
imports Main

begin

typedecl entity
typedecl event
typedecl int

consts
  Omnivore :: "entity ⇒ bool"
  Consumer :: "entity ⇒ bool"
  Feeds :: "entity ⇒ event ⇒ bool"
  Plant :: "entity ⇒ bool"
  Animal :: "entity ⇒ bool"
  TrophicLevel :: "event ⇒ int ⇒ bool"

(* Explanation 1: Omnivores are a type of consumer that can feed on both plant and animal material, and their trophic level in a feeding event is more than one. *)
axiomatization where
  explanation_1: "∀x. Omnivore x ⟶ (∃y z e i. Consumer x ∧ Feeds x e ∧ (Plant y ∨ Animal z) ∧ TrophicLevel e i ∧ i > 1)"

(* Explanation 2: If an omnivore consumer feeds on both plant and animal material in a feeding event, then the consumer has the ability to feed at a trophic level greater than one in that feeding event. *)
axiomatization where
  explanation_2: "∀x y z e i. Omnivore x ∧ Feeds x e ∧ Plant y ∧ Animal z ⟶ TrophicLevel e i ∧ i > 1"

theorem hypothesis:
  assumes asm: "Omnivore x"
  (* Hypothesis: Omnivores can feed at more than one trophic level. *)
  shows "∃e i. Feeds x e ∧ TrophicLevel e i ∧ i > 1"
proof -
  from asm have "∃y z e i. Consumer x ∧ Feeds x e ∧ (Plant y ∨ Animal z) ∧ TrophicLevel e i ∧ i > 1" using explanation_1 by blast.
  then obtain y z e i where c1: "Consumer x" "Feeds x e" "Plant y ∨ Animal z" "TrophicLevel e i" "i > 1" by auto.
  from asm have "∀x y z e i. Omnivore x ∧ Feeds x e ∧ Plant y ∧ Animal z ⟶ TrophicLevel e i ∧ i > 1" using explanation_2 by blast.
  then have "TrophicLevel e i ∧ i > 1" if "Feeds x e" "Plant y" "Animal z" using c1 by auto.
  then have "∃e i. Feeds x e ∧ TrophicLevel e i ∧ i > 1" using c1 by auto.
  then show ?thesis by auto.
qed

end
