theory question_94_1
imports Main

begin

typedecl entity
typedecl event

consts
  FourWheelDrive :: "entity ⇒ bool"
  Car :: "entity ⇒ bool"
  RoughRoad :: "entity ⇒ bool"
  WindingMountainRoad :: "entity ⇒ bool"
  Travels :: "entity ⇒ entity ⇒ bool"
  Sped :: "entity ⇒ entity ⇒ bool"
  Engine :: "entity ⇒ bool"
  Purring :: "entity ⇒ bool"
  Background :: "entity ⇒ bool"

(* Explanation 1: Four-wheel drive means the car can travel on rough roads. *)
axiomatization where
  explanation_1: "∀x. FourWheelDrive x ⟶ (Car x ⟶ (∃y. RoughRoad y ⟶ Travels x y))"

theorem hypothesis:
  (* Premise: The car sped along the winding mountain road, the engine purring softly in the background. *)
  assumes asm: "Car x ∧ WindingMountainRoad y ∧ Sped x y ∧ Engine z ∧ Purring z ∧ Background z"
  (* Hypothesis: The car travels along the road. *)
  shows "∃x. Car x ∧ Road y ∧ Travels x y"
proof -
  from asm have "Car x" by blast
  then have "FourWheelDrive x ⟶ (Car x ⟶ (∃y. RoughRoad y ⟶ Travels x y))" by fact
  with asm have "FourWheelDrive x ⟶ (∃y. RoughRoad y ⟶ Travels x y)" by blast
  then have "∃y. RoughRoad y ⟶ Travels x y" by blast
  then have "RoughRoad y ⟶ Travels x y" for y by blast
  with asm have "Travels x y" by blast
  then show "∃x. Car x ∧ Road y ∧ Travels x y" using asm by blast
qed

end
