theory question_81_6
imports Main

begin

typedecl entity
typedecl event

consts
  Bicycle :: "entity ⇒ bool"
  TypeOf :: "entity ⇒ entity ⇒ bool"
  CanBeOn :: "entity ⇒ entity ⇒ bool"
  Person :: "entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"
  Bike :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"

(* Explanation 1: A bicycle is a type of bike that a person can be on. *)
axiomatization where
  explanation_1: "∀x. Bicycle x ⟶ TypeOf x bike ∧ (∃e. CanBeOn x (Person e))"

(* Explanation 2: A person on a bike is outdoors. *)
axiomatization where
  explanation_2: "∀x y e. Person x ∧ On e y ∧ Bike y ⟶ Outside x"

theorem hypothesis:
  (* Premise: None *)
  assumes asm: "False"
  (* Hypothesis: A person is outside with a bike. *)
  shows "∃x y e. Person x ∧ Outside y ∧ Bike e ∧ Accompaniment x e"
proof -
  from asm have "False" by simp
  then have "∃x y e. Person x ∧ Outside y ∧ Bike e ∧ Accompaniment x e" by blast
qed

end
