theory question_51_0

imports Main

begin

typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  GivesSpeech :: "entity ⇒ event ⇒ bool"
  Speaking :: "entity ⇒ event ⇒ bool"
  Party :: "entity ⇒ bool"
  Ornate :: "entity ⇒ bool"
  Costume :: "entity ⇒ bool"
  At :: "event ⇒ entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: If someone gives a speech that means that they are speaking. *)
axiomatization where
  explanation_1: "∀x e1 e2. GivesSpeech x e1 ⟶ Speaking x e2"

theorem hypothesis:
  (* Premise: A man gives a speech at an ornate costume party. *)
  assumes asm: "Man x  ∧ GivesSpeech x  e  ∧ Party y  ∧ Ornate y  ∧ Costume z  ∧ At e  y  ∧ Wearing x  z "
  (* Hypothesis: A man is public speaking. *)
  shows "∃x e. Man x  ∧ Speaking x  e "
proof -
  from asm have "GivesSpeech x e" by blast
  then have "Speaking x e2" for some e2 using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
