theory question_81_3
imports Main

begin

typedecl entity
typedecl event

consts
  Soil :: "entity ⇒ bool"
  Nonliving :: "entity ⇒ bool"
  Typically :: "(entity ⇒ entity ⇒ bool) ⇒ (entity ⇒ bool) ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  Environment :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"

(* Explanation 1: Soil is a nonliving entity that is typically part of an environment. *)
axiomatization where
  explanation_1: "∀x. Soil x ⟶ (Nonliving x ∧ Typically (λz. PartOf x z) (Environment))"

(* Explanation 2: A forest is a type of environment. *)
axiomatization where
  explanation_2: "∀x. Forest x ⟶ Environment x"

(* Explanation 3: If an entity is typically part of an environment of a certain type, then it is part of that type of environment. *)
axiomatization where
  explanation_3: "∀x y. Typically (λz. PartOf x z) (Environment y) ⟶ PartOf x y"

theorem hypothesis:
  assumes asm: "Soil x"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "Nonliving x ∧ [∃y. Forest y ∧ PartOf x y]"
proof -
  {
    assume asm: "Soil x"
    from asm have "Nonliving x" by (simp add: explanation_1)
    then have "Typically (λz. PartOf x z) (Environment)" by (simp add: explanation_1)
    then obtain y where "Forest y" and "PartOf x y" by (auto intro: explanation_3)
  }
  thus "Nonliving x ∧ [∃y. Forest y ∧ PartOf x y]" by blast
qed

end
