theory question_72_2
imports Main

begin

typedecl entity
typedecl event

consts
  Riding :: "entity ⇒ entity ⇒ bool"
  Something :: "entity ⇒ bool"
  Surface :: "entity ⇒ bool"
  Moving :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Over :: "event ⇒ entity ⇒ bool"
  MovedAgainst :: "event ⇒ bool"
  MovedOver :: "event ⇒ bool"
  MovedDown :: "event ⇒ bool"
  Touching :: "entity ⇒ entity ⇒ bool"
  Friction :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Speed :: "event ⇒ bool"
  Causing :: "event ⇒ entity ⇒ bool"
  Decrease :: "event ⇒ bool"
  Child :: "entity ⇒ bool"
  Human :: "entity ⇒ bool"
  Vehicle :: "entity ⇒ bool"
  Hill :: "entity ⇒ bool"
  CanRide :: "entity ⇒ entity ⇒ bool"
  Stop :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Riding something is moving that thing over a surface. *)
axiomatization where
  explanation_1: "∀x y z e. Riding x y ∧ Something y ∧ Surface z ⟶ (∃e. Moving e ∧ Agent e x ∧ Patient e y ∧ Over e z)"

(* Explanation 2: If one surface is moved against, moved over, or moved down another surface, then those surfaces are touching. *)
axiomatization where
  explanation_2: "∀x y e1 e2 e3. Surface x ∧ Surface y ∧ (MovedAgainst e1 ∨ MovedOver e2 ∨ MovedDown e3) ∧ (Agent e1 x ∧ Patient e1 y ∨ Agent e2 x ∧ Patient e2 y ∨ Agent e3 x ∧ Patient e3 y) ⟶ Touching x y"

(* Explanation 3: Friction causes the speed of an object to decrease when the surfaces are touching. *)
axiomatization where
  explanation_3: "∀x y z e1 e2. Friction x ∧ Object y ∧ Surface z ∧ Touching z z ∧ (∃e1. Speed e1 ∧ Agent e1 y) ⟶ [(∃e2. Causing e2 ∧ Agent e2 x ∧ Patient e2 e1 ∧ Decrease e1)]"

(* Explanation 4: A child is a kind of human. *)
axiomatization where
  explanation_4: "∀x. Child x ⟶ Human x"

(* Explanation 5: Humans can ride vehicles. *)
axiomatization where
  explanation_5: "∀x y. Human x ∧ Vehicle y ⟶ CanRide x y"

(* Explanation 6: A hill is a kind of surface. *)
axiomatization where
  explanation_6: "∀x. Hill x ⟶ Surface x"

theorem hypothesis:
  (* Premise: a child rides a wagon down a hill. *)
  assumes asm: "Child x ∧ Wagon y ∧ Hill z ∧ Rides e ∧ Agent e x ∧ Patient e y ∧ Down e z"
  (* Premise: eventually, the wagon comes to a stop. *)
  assumes asm2: "∃x. Wagon x ∧ (∃e. Comes e ∧ Agent e x ∧ Stop e x)"
  (* Hypothesis: Friction acting on the wagon is responsible for causing the wagon to stop. *)
  shows "∃x y e1 e2. Friction x ∧ Wagon y ∧ Acting e1 ∧ Agent e1 x ∧ Patient e1 y ∧  Causing e2 ∧ Agent e2 x ∧ Patient e2 e1 ∧ Stop e1 y "
proof -
  {
    assume asm: "Child x ∧ Wagon y ∧ Hill z ∧ Rides e ∧ Agent e x ∧ Patient e y ∧ Down e z"
    assume asm2: "∃x. Wagon x ∧ (∃e. Comes e ∧ Agent e x ∧ Stop e x)"
    from asm have "Riding x y" by simp
    from explanation_6 have "Surface z" using Hill z by blast
    from ‹Riding x y› ‹Surface z› have "∃e. Moving e ∧ Agent e x ∧ Patient e y ∧ Over e z" using explanation_1 by blast
    from ‹Moving e ∧ Agent e x ∧ Patient e y ∧ Over e z› have "MovedDown e z" by simp
    from ‹MovedDown e z› ‹Surface z› have "Touching z z" using explanation_2 by blast
    from explanation_3 have "Friction x ∧ Object y ∧ Surface z ∧ Touching z z ∧ (∃e. Speed e ∧ Agent e y) ⟹ [(∃e. Causing e ∧ Agent e x ∧ Patient e e ∧ Decrease e)]" by blast
    from asm have "Object y" by simp
    from asm2 have "∃e. Speed e ∧ Agent e y" by blast
    from ‹Friction x ∧ Object y ∧ Surface z ∧ Touching z z ∧ (∃e. Speed e ∧ Agent e y)› have "∃e. Causing e ∧ Agent e x ∧ Patient e e ∧ Decrease e" using explanation_3 by blast
    from ‹∃e. Causing e ∧ Agent e x ∧ Patient e e ∧ Decrease e› have "∃e1 e2. Friction x ∧ Wagon y ∧ Acting e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Causing e2 ∧ Agent e2 x ∧ Patient e2 e1 ∧ Stop e1 y" by blast
  }
  then show ?thesis using asm asm2 by blast
qed

end
