theory question_77_1

imports Main

begin

typedecl entity

consts
  Mollusks :: "entity ⇒ bool"
  Exceptions :: "entity ⇒ bool"
  HasShell :: "entity ⇒ bool"
  Mussels :: "entity ⇒ bool"
  BivalveMollusks :: "entity ⇒ bool"

(* Explanation 1: Most mollusks, excluding a few exceptions, have shells. *)
axiomatization where
  explanation_1: "∀x. Mollusks x ∧ ¬Exceptions x ⟶ HasShell x"

(* Explanation 2: Mussels are a type of bivalve mollusks and do not belong to the exceptions mentioned in explanation 1. *)
axiomatization where
  explanation_2: "∀x. Mussels x ⟶ BivalveMollusks x ∧ ¬Exceptions x"

theorem hypothesis:
  assumes asm: "Mussels x"
  (* Hypothesis: Mussels have a shell. *)
  shows "HasShell x"
proof -
  from asm have "Mussels x" by simp
  then have "BivalveMollusks x ∧ ¬Exceptions x" using explanation_2 by blast
  then have "Mollusks x ∧ ¬Exceptions x" using ‹BivalveMollusks x› by blast
  then have "HasShell x" using explanation_1 by blast
  show ?thesis using asm ‹HasShell x› by blast
qed

end
