theory question_70_0
imports Main

begin

typedecl entity
typedecl event

consts
  Most :: "(entity set) ⇒ bool"
  Ecosystems :: "entity set ⇒ bool"
  Sunlight :: "event ⇒ bool"
  GetEnergy :: "entity set ⇒ event ⇒ bool"
  ElectromagneticEnergy :: "event ⇒ bool"
  Electromagnetism :: "event ⇒ bool"  -- New const added

(* Explanation 1: Most ecosystems get energy from sunlight. *)
axiomatization where
  explanation_1: "∀x e. Most x ∧ Ecosystems x ∧ Sunlight e ⟹ GetEnergy x e"

(* Explanation 2: Sunlight is a form of electromagnetic energy. *)
axiomatization where
  explanation_2: "∀x. Sunlight x ⟹ ElectromagneticEnergy x"

theorem hypothesis:
  assumes asm: "Ecosystems x ∧ ElectromagneticEnergy e"
  (* Hypothesis: Ecosystems get energy from electromagnetism. *)
  shows "GetEnergy x e"
proof -
  from asm have "Ecosystems x" by simp
  then obtain xs where "Most xs" and "x ∈ xs" using Most_def by blast
  from this[unfolded Most_def] and asm have "∃e. Sunlight e ∧ GetEnergy xs e" using explanation_1 by blast
  then obtain e where "Sunlight e" and "GetEnergy xs e" by blast
  then have "GetEnergy x e" using explanation_2 asm by blast
  then show ?thesis by simp
qed

end
