theory question_68_0
imports Main

begin

typedecl entity
typedecl event

consts
  Evolution :: "event ⇒ bool"
  OccursBy :: "event ⇒ entity ⇒ bool"
  NaturalSelectionEvent :: event
  NaturalSelection :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Survive :: "entity ⇒ bool"
  ElectingToSurvive :: "event ⇒ bool"

(* Explanation 1: Evolution occurs by a process called natural selection. *)
axiomatization where
  explanation_1: "Evolution NaturalSelectionEvent ∧ OccursBy NaturalSelectionEvent NaturalSelection"

(* Explanation 2: Evolution is about electing to survive. *)
axiomatization where
  explanation_2: "∀x. Evolution x ⟷ ElectingToSurvive x"

theorem hypothesis:
  assumes asm: "NaturalSelection x ∧ Agent NaturalSelectionEvent x"
  (* Hypothesis: Natural selection helps them survive. *)
  shows "Survive x"
proof -
  have "Evolution NaturalSelectionEvent" using explanation_1 by blast
  then have "ElectingToSurvive NaturalSelectionEvent" using explanation_2 by blast
  then have "∃e. ElectingToSurvive e ∧ Agent e x" using asm by blast
  then have "Survive x" using explanation_2 by blast
  show ?thesis using asm by blast
qed

end
