theory question_20_1

imports Main

begin

typedecl entity
typedecl event

consts
  Hair :: "entity ⇒ bool"
  Fiber :: "entity ⇒ bool"
  Mammals :: "entity ⇒ bool"
  Fur :: "entity ⇒ bool"

(* Explanation 1: Hair is a type of fiber that is found only in mammals. *)
axiomatization where
  explanation_1: "∀x. Hair x ⟶ Fiber x ∧ Mammals x"

(* Explanation 2: All mammals have fur, and some mammals have hair, which is a type of fur. *)
axiomatization where
  explanation_2: "∀x. Mammals x ⟶ (Fur x ∧ (∃y. Hair y ∧ Fur y ∧ Mammals y))"

(* Explanation 3: Fur is a type of fiber that is unique to mammals. *)
axiomatization where
  explanation_3: "∀x. Fur x ⟶ Fiber x ∧ Mammals x"

theorem hypothesis:
  assumes asm: "Fur x"
  (* Hypothesis: Fur is unique to mammals. *)
  shows "Mammals x"
proof -
  from asm have "Fur x" by simp
  then have "Fiber x ∧ Mammals x" using explanation_3 by blast
  then show "Mammals x" by simp
qed

end
