theory question_20_0

imports Main

begin

typedecl entity

consts
  Hair :: "entity ⇒ bool"
  Fiber :: "entity ⇒ bool"
  Mammals :: "entity ⇒ bool"
  Fur :: "entity ⇒ bool"

(* Explanation 1: Hair is a fiber that is found only in mammals. *)
axiomatization where
  explanation_1: "∀x. Hair x ⟶ Fiber x ∧ Mammals x"

(* Explanation 2: All mammals have fur or hair. *)
axiomatization where
  explanation_2: "∀x. Mammals x ⟶ Fur x ∨ Hair x"

theorem hypothesis:
  assumes asm: "Fur x"
  (* Hypothesis: Fur is unique to mammals. *)
  shows "Mammals x"
proof -
  from asm have "Fur x" by simp
  then obtain h where h: "Hair h" using explanation_2 by blast
  from h have "Mammals h" using explanation_1 by blast
  then have "Fur h ∨ Hair h" using explanation_2 by blast
  then have "Fur h" using h by blast
  then have "Fur x ∧ Fur h" by simp
  then have "x = h" using Fur_unique by blast
  then show ?thesis using asm `Mammals h` by blast
qed

end
