theory question_89_0
imports Main

begin
typedecl entity
typedecl event

consts
  MountainBiking :: "entity ⇒ bool"
  Bike :: "entity ⇒ bool"
  Bicycling :: "entity ⇒ bool"
  Uses :: "entity ⇒ entity ⇒ bool"
  Woods :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"
  Autumn :: "entity ⇒ bool"
  Fall :: "entity ⇒ bool"
  Through :: "event ⇒ entity ⇒ bool"
  In :: "event ⇒ entity ⇒ bool"
  EarlyFall :: "entity ⇒ bool"

(* Explanation 1: Mountain biking uses bikes and can thus be generically called bicycling. The woods is another word for forest. Autumn is another word for the season of fall. *)
axiomatization where
  explanation_1: "∀x y z. MountainBiking x ∧ Bike y ∧ Bicycling z ⟶ Uses x y ∧ (Woods z ⟷ Forest z) ∧ (Autumn z ⟷ Fall z)"

theorem hypothesis:
  (* Premise: Mountain biking in a forest during the early fall. *)
  assumes asm: "MountainBiking e ∧ Agent e x ∧ In e_forest Forest ∧ During e EarlyFall"
  (* Hypothesis: Bicycling through the woods in the Autumn. *)
  shows "∃x e. Bicycling e ∧ Agent e x ∧ Through e Woods ∧ In e Autumn"
proof -
  from asm have "MountainBiking e" by blast
  from asm have "In e_forest Forest" by blast
  from asm have "During e EarlyFall" by blast
  from explanation_1[OF this this] have "Bicycling e" by blast
  from explanation_1[OF this this] have "Forest ⟷ Woods" by blast
  from explanation_1[OF this this] have "EarlyFall ⟷ Autumn" by blast
  from ‹Forest ⟷ Woods› and ‹In e_forest Forest› have "In e_forest Woods" by blast
  from ‹EarlyFall ⟷ Autumn› and ‹During e EarlyFall› have "During e Autumn" by blast
  then show ?thesis using asm `e` `x` by blast
qed

end
