theory question_67_10

imports Main

begin
typedecl entity
typedecl event

consts
  RiverBoatTour :: "entity ⇒ bool"
  Event :: "event ⇒ bool"
  Boat :: "entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"
  SameLocation :: "entity ⇒ entity ⇒ bool"
  Male :: "entity ⇒ bool"
  OlderMale :: "entity ⇒ bool"
  SittingOn :: "entity ⇒ entity ⇒ bool"
  Together :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A river boat tour is an event where entities are on a boat. *)
axiomatization where
  explanation_1: "∀x. RiverBoatTour x ⟶ (∃e z. Event e ∧ Boat z ∧ On e z)"

(* Explanation 2: Entities that are on the same boat are in the same location. *)
axiomatization where
  explanation_2: "∀x y z. On x z ∧ On y z ∧ Boat z ⟶ SameLocation x y"

theorem hypothesis:
  (* Premise: Two older males sitting together on a river boat tour. *)
  assumes asm: "OlderMale x ∧ OlderMale y ∧ Boat z ∧ RiverBoatTour e ∧ x ≠ y ∧ SittingOn x z ∧ SittingOn y z ∧ Together x y ∧ On e z"
  (* Hypothesis: Two males sitting together on a boat *)
  shows "∃x y z. Male x ∧ Male y ∧ Boat z ∧ x ≠ y ∧ SittingOn x z ∧ SittingOn y z ∧ Together x y"
proof -
  {
    assume "RiverBoatTour e" and "On e z"
    then obtain e' where "Event e'" and "Boat z" and "On e' z" by (rule explanation_1)
    then have "SameLocation x y" if "On x z" and "On y z" for x y
      using explanation_2 by blast
  }
  with asm have "SameLocation x y" and "Boat z" by blast
  with asm have "Male x" and "Male y" using OlderMale_def by blast+
  with asm show ?thesis by blast
qed

end
