theory question_66_0
imports Main
begin

typedecl entity
typedecl event

consts
  Bartender :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Black :: "entity ⇒ bool"
  Male :: "entity ⇒ bool"
  Dressed :: "entity ⇒ bool"
  Sleeves :: "entity ⇒ bool"
  RolledUp :: "entity ⇒ bool"
  ElbowHeight :: "entity ⇒ bool"
  Drink :: "entity ⇒ bool"
  MartiniGlass :: "entity ⇒ bool"
  Making :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A bartender, who is a person, is wearing black. *)
axiomatization where
  explanation_1: "∃x. Bartender x ∧ Person x ∧ ∃z. Wearing x z ∧ Black z"

theorem hypothesis:
  (* Premise: A male bartender dressed in all black with his sleeves rolled up to elbow height making a drink in a martini glass. *)
  assumes asm: "Male x ∧ Bartender x ∧ Dressed x ∧ Black z ∧ Sleeves z ∧ RolledUp z ∧ ElbowHeight z ∧ Drink y ∧ MartiniGlass y ∧ Making e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: A person in black *)
  shows "∃x. Person x ∧ Black x"
proof -
  {
    assume "Male x ∧ Bartender x ∧ Dressed x ∧ Black z ∧ Sleeves z ∧ RolledUp z ∧ ElbowHeight z ∧ Drink y ∧ MartiniGlass y ∧ Making e ∧ Agent e x ∧ Patient e y"
    then obtain z' where "Wearing x z' ∧ Black z'" using explanation_1 by blast
    then have "Person x ∧ Black z'" by blast
    then show "∃x. Person x ∧ Black x" using this by blast
  }
qed

end
