theory question_81_1

imports Main

begin

typedecl entity
typedecl event

consts
  BottleneckEffect :: "entity ⇒ bool"
  Population :: "entity ⇒ bool"
  Suddenly :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  ExternalFactors :: "event ⇒ entity ⇒ bool"
  ExternalMigration :: "entity ⇒ bool"
  PopulationGrowth :: "entity ⇒ bool"
  Decrease :: "event ⇒ bool"

(* Explanation 1: Bottleneck effect occurs when a population suddenly gets much smaller due to external factors such as habitat destruction, natural disasters, or overhunting. *)
axiomatization where
  explanation_1: "∀x y e. BottleneckEffect x ∧ Population y ∧ Suddenly e ∧ Agent e x ∧ Patient e y ∧ ExternalFactors e y"

(* Explanation 2: External migration reduces population growth by decreasing the number of individuals in the population, which can lead to a bottleneck effect. *)
axiomatization where
  explanation_2: "∀x y e. ExternalMigration x ∧ PopulationGrowth y ∧ Decrease e ∧ Agent e x ∧ Patient e y ∧ BottleneckEffect e"

theorem hypothesis:
  assumes asm: "ExternalMigration x ∧ PopulationGrowth y"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃x y e. BottleneckEffect x ∧ Population y ∧ Suddenly e ∧ Agent e x ∧ Patient e y ∧ ExternalFactors e y"
proof -
  from asm have "ExternalMigration x ∧ PopulationGrowth y" by simp
  then obtain e1 where e1: "BottleneckEffect x ∧ Population y ∧ Suddenly e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ExternalFactors e1 y" using explanation_1 by blast
  then have "ExternalMigration x ∧ Decrease e1 ∧ Agent e1 x ∧ Patient e1 y" using explanation_2 by blast
  have conclusion: "BottleneckEffect x ∧ Population y ∧ Suddenly e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ExternalFactors e1 y" using e1 by simp
  show ?thesis using asm conclusion `ExternalMigration x ∧ Decrease e1 ∧ Agent e1 x ∧ Patient e1 y` by blast
qed

end
