theory question_40_1

imports Main

begin

typedecl entity
typedecl event

consts
  LightBulbs :: "entity ⇒ bool"
  Electricity :: "entity ⇒ bool"
  Convert :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  ElectricalEnergy :: "entity ⇒ bool"
  Energy :: "entity ⇒ bool"
  OtherEnergy :: "entity ⇒ bool"

(* Explanation 1: Some light bulbs convert electricity into light and heat energy. *)
axiomatization where
  explanation_1: "∀x y e. LightBulbs x ∧ Electricity y ∧ Convert e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: Electrical energy is also energy. *)
axiomatization where
  explanation_2: "∀x. ElectricalEnergy x ∧ Energy x"

(* Explanation 3: Some light bulbs convert other energy into light and heat energy. *)
axiomatization where
  explanation_3: "∀x y e. LightBulbs x ∧ OtherEnergy y ∧ Convert e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  assumes asm: "LightBulbs x ∧ OtherEnergy y ∧ Convert e"
  (* Hypothesis: Some light bulbs convert other energy into light and heat energy. *)
  shows "∃x y z e. LightBulbs x ∧ OtherEnergy y ∧ Convert e ∧ Agent e x ∧ Patient e z ∧ Energy z"
proof -
  from asm have "LightBulbs x ∧ OtherEnergy y ∧ Convert e" by simp
  then obtain z where z: "Energy z" using explanation_2 by blast
  then have "Agent e x ∧ Patient e y ∧ Energy z" using explanation_1 by blast
  show ?thesis using asm z by simp
qed

end
