theory question_77_0

imports Main

begin

typedecl entity
typedecl event
consts
  Colour :: "entity ⇒ bool"
  GoldenColored :: "entity ⇒ bool"
  LightColored :: "entity ⇒ bool"
  Dog :: "entity ⇒ bool"
  Holds :: "event ⇒ entity ⇒ bool"
  TennisBall :: "event ⇒ bool"
  BrightlyColored :: "event ⇒ bool"
  EyesAlert :: "entity ⇒ bool"

(* Explanation 1: The colour gold is a light one, thus a golden-colored dog is a light-colored dog. *)
axiomatization where
  explanation_1: "∀x. Colour x ∧ GoldenColored x ⟶ LightColored x"

theorem hypothesis:
  (* Premise: A golden-colored dog, with his eyes alert, holds a brightly colored tennis ball in his mouth. *)
  assumes asm: "Dog x  ∧ GoldenColored y  ∧ EyesAlert x  ∧ TennisBall e  ∧ BrightlyColored e  ∧ Holds e  x "
  (* Hypothesis: The dog is light colored. *)
  shows "∃x. Dog x  ∧ LightColored x "
proof -
  from asm have "Dog x" by blast
  from this have "GoldenColored y" using `asm` by blast
  from explanation_1 have "LightColored z" using `GoldenColored y` by blast
  show ?thesis using `Dog x` `LightColored z` by blast
qed

end
