theory question_35_5

imports Main

begin

typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  RedBicycleHelmet :: "entity ⇒ bool"
  Talking :: "event ⇒ bool"
  Cellphone :: "entity ⇒ bool"
  OtherPeople :: "entity ⇒ bool"
  InBackground :: "entity ⇒ event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A man wearing a red bicycle helmet talking on a cellphone with other people in the background implies that a man talks on a cellphone. *)
axiomatization where
  explanation_1: "∃x y z e. Man x ∧ Wearing y x ∧ RedBicycleHelmet y ∧ Talking e ∧ Cellphone z ∧ OtherPeople z ∧ InBackground z e ∧ Agent e x"

theorem hypothesis:
  (* Premise: A man wearing a red bicycle helmet talking on a cellphone with other people in the background. *)
  assumes asm: "Man x ∧ Wearing y x ∧ RedBicycleHelmet y ∧ Talking e ∧ Cellphone z ∧ OtherPeople z ∧ InBackground z e ∧ Agent e x"
  (* Hypothesis: A man talks on a cellphone. *)
  shows "∃x e. Man x ∧ Talking e ∧ Cellphone x"
proof -
  from asm have "Man x" using explanation_1 by blast
  from asm have "Talking e" using explanation_1 by blast
  from asm have "Cellphone z" using explanation_1 by blast
  show ?thesis using `Man x` `Talking e` `Cellphone z` by blast
qed

end
