theory question_87_7

imports Main

begin

typedecl entity
typedecl event

consts
  Limestone :: "entity ⇒ bool"
  Fossils :: "entity ⇒ bool"
  Contains :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  UsefulInStudyingHistoryOfLivingOrganisms :: "entity ⇒ bool"

(* Explanation 1: All limestone contains fossils. *)
axiomatization where
  explanation_1: "∀x y. Limestone x ∧ Fossils y ⟶ (∃e. Contains e ∧ Agent e x ∧ Patient e y)"

(* Explanation 2: Limestone is useful in studying the history of living organisms. *)
axiomatization where
  explanation_2: "∀x. Limestone x ⟶ UsefulInStudyingHistoryOfLivingOrganisms x"  

theorem hypothesis:
  assumes asm: "Limestone x"
  (* Hypothesis: Limestone is the rock type that is useful in studying the history of living organisms. *)
  shows "UsefulInStudyingHistoryOfLivingOrganisms x"
proof -
  from asm have "Limestone x" by simp
  then have "UsefulInStudyingHistoryOfLivingOrganisms x" using explanation_2 by blast
  then show ?thesis by simp
qed

end
