theory question_65_6

imports Main

begin

typedecl entity
typedecl event

consts
  Electricity :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Flows :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  TurnOn :: "event ⇒ bool"
  ComesOn :: "event ⇒ bool"
  Switch :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Includes :: "event ⇒ bool"
  Closed :: "event ⇒ bool"
  Starts :: "event ⇒ bool"
  Flowing :: "event ⇒ bool"

(* Explanation 1: When electricity flows to a light bulb, the light bulb will turn on; come on. *)
axiomatization where
  explanation_1: "∀x y e1 e2. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ TurnOn e2 ∧ Agent e2 y ∧ ComesOn e2 ∧ Agent e2 y"

(* Explanation 2: When a switch in a simple series circuit that includes a light bulb is closed, electricity starts flowing from the switch to the light bulb in the circuit. *)
axiomatization where
  explanation_2: "∀x y z e1 e2 e3. Switch x ∧ SimpleSeriesCircuit y ∧ LightBulb z ∧ Includes e1 ∧ Agent e1 y ∧ Patient e1 z ∧ Closed e2 ∧ Agent e2 x ⟶ Starts e3 ∧ Flowing e3 ∧ Agent e3 x ∧ Patient e3 z"  

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "Switch x ∧ SimpleSeriesCircuit y ∧ Closed e ∧ Agent e x"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃x y e1 e2. Electricity x ∧ LightBulb y ∧ Flowing e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ComesOn e2 ∧ Agent e2 y"
proof -
  obtain z e1 where e1: "SimpleSeriesCircuit y ∧ LightBulb z ∧ Includes e1 ∧ Agent e1 y ∧ Patient e1 z" using explanation_2 asm by blast
  then obtain e2 where e2: "Starts e2 ∧ Flowing e2 ∧ Agent e2 x ∧ Patient e2 z" using explanation_2 asm by blast
  then have "Electricity x" using explanation_2 asm by blast
  then have "ComesOn e2 ∧ Agent e2 z" using explanation_1 e1 e2 by blast
  show ?thesis using asm e1 e2 `Electricity x` `ComesOn e2 ∧ Agent e2 z` by blast
qed

end
