theory question_27_10

imports Main

begin

typedecl entity

consts
  AbleToRead :: "entity ⇒ bool"
  LearnedTrait :: "entity ⇒ bool"
  Example :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Being able to read is a learned trait. *)
axiomatization where
  explanation_1: "∀x y. AbleToRead x ⟶ LearnedTrait y"

theorem hypothesis:
  assumes asm: "AbleToRead x"
  (* Hypothesis: Being able to read is an example of a learned trait. *)
  shows "∃y. LearnedTrait y ∧ Example x y"
proof -
  from asm have "AbleToRead x" by simp
  then have "LearnedTrait y" using explanation_1 by blast
  then have "Example x y" by simp
  show ?thesis using `LearnedTrait y` `Example x y` by blast
qed

end
