theory question_77_0

imports Main

begin

typedecl entity

consts
  Mollusks :: "entity ⇒ bool"
  Shell :: "entity ⇒ bool"
  Mussels :: "entity ⇒ bool"
  BivalveMollusks :: "entity ⇒ bool"

(* Explanation 1: Most mollusks have shells. *)
axiomatization where
  explanation_1: "∀x. Mollusks x ⟶ Shell x"

(* Explanation 2: Mussels are bivalve mollusks. *)
axiomatization where
  explanation_2: "∀x. Mussels x ⟶ BivalveMollusks x"  

theorem hypothesis:
  assumes asm: "Mussels x"
  (* Hypothesis: Mussels have a shell. *)
  shows "Shell x"
proof -
  from asm have "Mussels x" by simp
  then have "BivalveMollusks x" using explanation_2 by blast
  then have "Mollusks x" using explanation_2 by blast
  then have "Shell x" using explanation_1 by blast
  show ?thesis using `Shell x` by blast
qed

end
