theory question_74_2
imports Main

begin

typedecl entity
typedecl event

consts
  Fibres :: "entity ⇒ bool"
  Paper :: "entity ⇒ bool"
  Trees :: "entity ⇒ bool"
  Pulping :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Require :: "event ⇒ bool"
  Cutting :: "event ⇒ bool"
  Saving :: "event ⇒ bool"
  NonWoodFibres :: "entity ⇒ bool"
  Pulped :: "event ⇒ bool"
  Contributing :: "event ⇒ bool"
  Saves :: "event ⇒ bool"

(* Explanation 1: Pulping fibres for paper does not require cutting down trees, thus saving trees. *)
axiomatization where
  explanation_1: "∀x y z e1 e2 e3. Fibres x ∧ Paper y ∧ Trees z ∧ Pulping e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ¬Require e2 ∧ Agent e2 x ∧ Cutting e3 ∧ Agent e3 z ⟶ Saving e2 ∧ Agent e2 x ∧ Patient e2 z"

(* Explanation 2: Dozens of non-wood fibers are pulped for paper around the world, contributing to the saving of trees. *)
axiomatization where
  explanation_2: "∀x y z e1 e2. NonWoodFibres x ∧ Paper y ∧ Trees z ∧ Pulped e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ Contributing e2 ∧ Agent e2 x ∧ Saving e2 ∧ Patient e2 z"  

theorem hypothesis:
  assumes asm: "Fibres x ∧ Paper y ∧ Trees z ∧ Pulping e1 ∧ Agent e1 x ∧ Patient e1 y"
  (* Hypothesis: Pulping fibres for paper saves trees. *)
  shows "∃x y z e1 e2. Fibres x ∧ Paper y ∧ Trees z ∧ Pulping e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Saves e2 ∧ Agent e2 x ∧ Patient e2 z"
proof -
  from asm have "Fibres x ∧ Paper y ∧ Trees z ∧ Pulping e1 ∧ Agent e1 x ∧ Patient e1 y" by simp
  then obtain e2 where e2: "Saving e2 ∧ Agent e2 x ∧ Patient e2 z" using explanation_1 by blast
  then have "NonWoodFibres x" using explanation_2 by blast
  have conclusion: "Saves e2 ∧ Agent e2 x ∧ Patient e2 z" using e2 by simp
  show ?thesis using asm conclusion `NonWoodFibres x` by blast
qed

end
