theory question_17_1

imports Main

begin

typedecl entity
typedecl event

consts
  Consumers :: "entity ⇒ bool"
  TrophicLevel :: "entity ⇒ bool"
  MoreThanOne :: "entity ⇒ bool"
  Feed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Omnivores :: "entity ⇒ bool"

(* Explanation 1: Many consumers feed at more than one trophic level. *)
axiomatization where
  explanation_1: "∀x y e. Consumers x ∧ TrophicLevel y ∧ MoreThanOne y ∧ Feed e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: Omnivores are a type of consumers. *)
axiomatization where
  explanation_2: "∀x. Omnivores x ⟶ Consumers x"  

theorem hypothesis:
  assumes asm: "Omnivores x"
  (* Hypothesis: Omnivores can feed at more than one trophic level. *)
  shows "∃x y e. Omnivores x ∧ TrophicLevel y ∧ MoreThanOne y ∧ Feed e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Consumers x" using explanation_2 by simp
  then obtain y e where "TrophicLevel y ∧ MoreThanOne y ∧ Feed e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
