theory question_94_1

imports Main

begin
typedecl entity
typedecl event

consts
  LittleBoy :: "entity ⇒ bool"
  Boy :: "entity ⇒ bool"
  Bathroom :: "entity ⇒ bool"
  Building :: "entity ⇒ bool"
  Inside :: "entity ⇒ entity ⇒ bool"
  Bathrobe :: "entity ⇒ bool"
  Bench :: "entity ⇒ bool"
  Shower :: "entity ⇒ bool"
  Sits :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Near :: "entity ⇒ entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A little boy is a boy. *)
axiomatization where
  explanation_1: "∀x. LittleBoy x ⟶ Boy x"

(* Explanation 2: A bathroom is inside a building. *)
axiomatization where  
  explanation_2: "∀x y. Bathroom x ∧ Building y ⟶ Inside x y"

theorem hypothesis:
  (* Premise: A little boy in a bathrobe sits on a bench near the shower in a bathroom. *)
  assumes asm: "LittleBoy x ∧ Bathrobe y ∧ Bench z ∧ Shower w ∧ Bathroom v ∧ Sits e ∧ Agent e x ∧ Patient e z ∧ Near z w ∧ In v x"
  (* Hypothesis: The boy is inside of the building. *)
  shows "∃x y. Boy x ∧ Building y ∧ Inside x y"
proof -
  from asm have "LittleBoy x" by blast
  then have "Boy x" using explanation_1 by blast
  from asm have "Bathroom v" by blast
  then have "Building y ∧ Inside v y" using explanation_2 by blast
  then show ?thesis using `Boy x` by blast
qed

end
