theory question_89_0
imports Main

begin
typedecl entity
typedecl event

consts
  MountainBiking :: "entity ⇒ bool"
  Bikes :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"
  Bicycling :: "event ⇒ bool"
  Woods :: "entity ⇒ bool"
  Autumn :: "entity ⇒ bool"
  Uses :: "event ⇒ bool"
  Called :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Through :: "event ⇒ entity ⇒ bool"
  In :: "event ⇒ entity ⇒ bool"
  EarlyFall :: "entity ⇒ bool"
  Biking :: "event ⇒ bool"
  During :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Mountain biking uses bikes and can thus be generically called bicycling. The woods is another word for forest. Autumn is another word for the season of fall. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. MountainBiking x ∧ Bikes y ∧ Forest z ∧ Uses e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Called e2 ∧ Agent e2 x ∧ Patient e2 y ⟶ Bicycling e2 ∧ Woods z ∧ Autumn z"

theorem hypothesis:
  (* Premise: Mountain biking in a forest during the early fall. *)
  assumes asm: "Person x ∧ Forest y ∧ EarlyFall z ∧ Biking e ∧ Agent e x ∧ In e y ∧ During e z"
  (* Hypothesis: Bicycling through the woods in the Autumn. *)
  shows "∃x y z e. Person x ∧ Woods y ∧ Autumn z ∧ Bicycling e ∧ Agent e x ∧ Through e y ∧ In e z"
proof -
  from asm have "Person x ∧ Forest y ∧ EarlyFall z ∧ Biking e ∧ Agent e x ∧ In e y ∧ During e z" by blast
  then have "Person x ∧ Woods y ∧ Autumn z ∧ Bicycling e ∧ Agent e x ∧ Through e y ∧ In e z" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
