theory question_30_3

imports Main

begin
typedecl entity
typedecl event

consts
  Skateboard :: "entity ⇒ bool"
  Tricks :: "entity ⇒ bool"
  Doing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Human :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Doing tricks on a skateboard is an action of doing tricks. *)
axiomatization where
  explanation_1: "∀x y e. Skateboard x ∧ Tricks y ∧ Doing e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: A man is a human. *)
axiomatization where
  explanation_2: "∀x. Man x ⟶ Human x"

theorem hypothesis:
  (* Premise: A man is doing tricks on a skateboard. *)
  assumes asm: "Man x ∧ Tricks y ∧ Skateboard z ∧ Doing e ∧ Agent e x ∧ Patient e y ∧ On x z"
  (* Hypothesis: A human doing tricks *)
  shows "∃x e. Human x ∧ Doing e ∧ Agent e x"
proof -
  from asm have "Man x ∧ Doing e ∧ Agent e x" by blast
  then have "Human x ∧ Doing e ∧ Agent e x" using explanation_2 by blast
  then show ?thesis using asm by blast
qed

end
