theory question_63_0
imports Main

begin

typedecl entity
typedecl event

consts
  WaterAnimal :: "entity ⇒ bool"
  Plant :: "entity ⇒ bool"
  FossilsOf :: "event ⇒ entity ⇒ bool"
  InPlace :: "entity ⇒ bool"
  CoveredByWaterInPast :: "event ⇒ bool"
  PlaceUsedToBeCoveredByWater :: "event ⇒ entity ⇒ bool"
  Trilobite :: "entity ⇒ bool"
  State :: "entity ⇒ bool"
  LocatedIn :: "entity ⇒ entity ⇒ bool"
  Ohio :: "entity ⇒ bool"

(* Explanation 1: if fossils of a water animal or plant are found in a place then that place used to be covered by water in the past. *)
axiomatization where
  explanation_1: "∀x y e. WaterAnimal x ∨ Plant x ∧ FossilsOf e x ∧ InPlace y ⟶ (∃e1. CoveredByWaterInPast e1 ∧ PlaceUsedToBeCoveredByWater e y)"

(* Explanation 2: a trilobite is a kind of water animal. *)
axiomatization where
  explanation_2: "∀x. Trilobite x ⟶ WaterAnimal x"

(* Explanation 3: Ohio is a state located in the United States of America. *)
axiomatization where
  explanation_3: "Ohio ⟶ State ∧ LocatedIn Ohio USA"

(* Explanation 4: a state is a kind of place. *)
axiomatization where
  explanation_4: "∀x. State x ⟶ Place x"


theorem hypothesis:
  (* Premise: the fossils of extinct sea animals called trilobites are found in ohio. *)
  assumes asm: "Trilobite x ∧ WaterAnimal x ∧ FossilsOf e x ∧ InPlace Ohio"
  (* Hypothesis: Ohio was once covered by water. *)
  shows "∃e. Ohio e ∧ CoveredByWaterInPast e"
proof -
  from asm have "WaterAnimal x" using explanation_2 by blast
  then have "∃e. CoveredByWaterInPast e ∧ PlaceUsedToBeCoveredByWater e Ohio" using explanation_1 by blast
  then obtain e where e: "CoveredByWaterInPast e ∧ PlaceUsedToBeCoveredByWater e Ohio" by blast
  have "Ohio e" using asm explanation_3 by blast
  then have "State e" using explanation_3 by blast
  then have "Place e" using explanation_4 by blast
  have conclusion: "CoveredByWaterInPast e" using e by blast
  show ?thesis using conclusion `Ohio e` by blast
qed

end
