theory question_87_0

imports Main

begin

typedecl entity
typedecl event

consts
  Tunicates :: "entity ⇒ bool"
  SexuallyReproduce :: "entity ⇒ bool"
  Reproduce :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Bulbs :: "entity ⇒ bool"
  Tunicate :: "entity ⇒ bool"
  NonTunicate :: "entity ⇒ bool"

(* Explanation 1: Tunicates reproduce sexually. *)
axiomatization where
  explanation_1: "∀x y e. Tunicates x ∧ SexuallyReproduce y ∧ Reproduce e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: Bulbs are classified as tunicate or non-tunicate. *)
axiomatization where
  explanation_2: "∀x. Bulbs x ⟶ (Tunicate x ∨ NonTunicate x)"

theorem hypothesis:
  assumes asm: "Bulbs x"
  (* Hypothesis: Bulbs reproduce sexually. *)
  shows "∃x y e. Bulbs x ∧ SexuallyReproduce y ∧ Reproduce e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Bulbs x" by simp
  then have "Tunicate x ∨ NonTunicate x" using explanation_2 by blast
  then consider cases
    assume "Tunicate x"
    then obtain y e where "SexuallyReproduce y ∧ Reproduce e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
    thus ?thesis using `Bulbs x` by blast
  next
    assume "NonTunicate x"
    then have "¬ SexuallyReproduce y ∧ ¬ Reproduce e ∧ ¬ Agent e x ∧ ¬ Patient e y" by auto
    then show ?thesis using `Bulbs x` by blast
  qed

end
