theory question_75_6
imports Main
begin

typedecl entity
typedecl event

consts
  ExtremeHeat :: "entity ⇒ bool"
  Pressure :: "entity ⇒ bool"
  Rock :: "entity ⇒ bool"
  Marble :: "entity ⇒ bool"
  Change :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  MetamorphicRock :: "entity ⇒ bool"
  FormOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Extreme heat and pressure change rock specifically into marble, which is a form of metamorphic rock. *)
axiomatization where
  explanation_1: "∀x y z e. ExtremeHeat x ∧ Pressure y ∧ Rock z ∧ Marble e ∧ Change e ∧ Agent e x ∧ Agent e y ∧ Patient e z ⟶ MetamorphicRock z ∧ FormOf z e"

(* Explanation 2: Metamorphic rock, as the result of extreme heat and pressure on rock, includes various specific forms such as marble. *)
axiomatization where
  explanation_2: "∀x y z. MetamorphicRock x ∧ ExtremeHeat y ∧ Pressure z ∧ Rock y ⟶ Includes x y ∧ Includes x z ∧ Specific x ∧ Forms x Marble"

theorem hypothesis:
  assumes asm: "ExtremeHeat x ∧ Pressure y ∧ Rock z"
  (* Hypothesis: Extreme heat and pressure change rock into marble. *)
  shows "∃x y z e. ExtremeHeat x ∧ Pressure y ∧ Rock z ∧ Marble e ∧ Change e ∧ Agent e x ∧ Agent e y ∧ Patient e z ∧ Patient e e"
proof -
  from asm have "ExtremeHeat x" and "Pressure y" and "Rock z" by auto
  then obtain e where e: "Marble e ∧ Change e ∧ Agent e x ∧ Agent e y ∧ Patient e z" using explanation_1 by blast
  then have "Patient e e" using e explanation_1 by blast
  show ?thesis using asm e by blast
qed

end
