theory question_88_3

imports Main

begin
typedecl entity
typedecl event
consts
  Gymnast :: "entity ⇒ bool"
  Skills :: "entity ⇒ bool"
  Flip :: "event ⇒ bool"
  Displays :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  BlueFlooring :: "event ⇒ bool"
  Does :: "event ⇒ bool"

(* Explanation 1: A gymnast displays their skills by executing a flip. *)
axiomatization where
  explanation_1: "∃x e. Gymnast x ∧ Skills x ∧ Flip e ∧ Displays e ∧ Agent e x"

theorem hypothesis:
  (* Premise: Gymnast does a flip on blue flooring. *)
  assumes asm: "Gymnast x ∧ Flip e ∧ BlueFlooring e ∧ Does e ∧ Agent e x"
  (* Hypothesis: A gymnast displays their skills with a flip. *)
  shows "∃x e. Gymnast x ∧ Skills x ∧ Flip e ∧ Displays e ∧ Agent e x"
proof -
  from asm have "Gymnast x ∧ Flip e" by blast
  then have "Gymnast x ∧ Skills x ∧ Flip e ∧ Displays e ∧ Agent e x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
