theory question_85_4

imports Main

begin
typedecl entity
typedecl event

consts
  FlowerCartVendor :: "entity ⇒ bool"
  FlowerSeller :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  Selling :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Location :: "event ⇒ entity ⇒ bool"
  Vendor :: "event ⇒ bool"

(* Explanation 1: Flower cart vendors on the sidewalk are flower sellers on the sidewalk. *)
axiomatization where
  explanation_1: "∀x y e. FlowerCartVendor x ∧ Sidewalk y ⟶ (∃z. FlowerSeller z ∧ Sidewalk y ∧ Selling e ∧ Agent e z ∧ Location e y)"

theorem hypothesis:
  (* Premise: Sidewalk flower cart vendor. *)
  assumes asm: "FlowerCartVendor x ∧ Sidewalk y ∧ Vendor e ∧ Agent e x ∧ Location e y"
  (* Hypothesis: Flower seller on sidewalk. *)
  shows "∃x y e. FlowerSeller x ∧ Sidewalk y ∧ Selling e ∧ Agent e x ∧ Location e y"
proof -
  from asm have "FlowerCartVendor x ∧ Sidewalk y" by blast
  then have "∃z. FlowerSeller z ∧ Sidewalk y ∧ Selling e ∧ Agent e z ∧ Location e y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
