theory question_81_4

imports Main

begin
typedecl entity
typedecl event

consts
  Bicycle :: "entity ⇒ bool"
  Outdoors :: "entity ⇒ bool"
  Riding :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  WithBike :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Helmet :: "entity ⇒ bool"
  Jumps :: "event ⇒ bool"
  Soaring :: "event ⇒ bool"
  Wears :: "event ⇒ bool"
  InFrontOf :: "entity ⇒ entity ⇒ bool"
  Skyline :: "entity"
  Lake :: "entity"

(* Explanation 1: Riding a bicycle outdoors implies the person is outside. *)
axiomatization where
  explanation_1: "∀x y e. Bicycle y ∧ Outdoors x ∧ Riding e ∧ Agent e x ∧ Patient e y ⟶ Outside x"

(* Explanation 2: Being on a bicycle indicates the person is with a bike. *)
axiomatization where
  explanation_2: "∀x y. Bicycle y ∧ On x y ⟶ WithBike x"

(* Explanation 3: A person on a bicycle outside is with a bike. *)
axiomatization where
  explanation_3: "∀x y. Bicycle y ∧ Outside x ∧ On x y ⟶ WithBike x"

(* Explanation 4: A person on a bicycle outside is outside. *)
axiomatization where
  explanation_4: "∀x. Outside x ⟶ (∃y. Bicycle y ∧ On x y)"

theorem hypothesis:
  (* Premise: A person on a bicycle wears a helmet and jumps, soaring over the ground in front of a skyline and lake. *)
  assumes asm: "Person x ∧ Bicycle y ∧ Helmet z ∧ Jumps e1 ∧ Soaring e2 ∧ Wears e3 ∧ On x y ∧ Agent e1 x ∧ Agent e2 x ∧ Agent e3 x ∧ Patient e3 z ∧ InFrontOf x Skyline ∧ InFrontOf x Lake"
  (* Hypothesis: A person outside with a bike. *)
  shows "∃x y. Person x ∧ Outside y ∧ WithBike x"
proof -
  from asm have "Person x ∧ Bicycle y ∧ On x y" by blast
  then have "WithBike x" using explanation_2 explanation_3 by blast
  then have "Outside y" using explanation_1 by blast
  then show ?thesis using `Person x` `Outside y` by blast
qed

end
