theory question_27_1
imports Main
begin

typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  DirtySidewalk :: "entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Outside :: "event ⇒ bool"
  Is :: "event ⇒ bool"
  Old :: "entity ⇒ bool"
  HardwareParts :: "entity ⇒ bool"
  Sells :: "event ⇒ bool"

(* Explanation 1: The man being on a dirty sidewalk implies that he is outside. *)
axiomatization where
  explanation_1: "∀x y e1 e2. Man x ∧ DirtySidewalk y ∧ On e1 y ∧ Agent e1 x ∧ Patient e1 y ⟶ Outside e2 ∧ Is e2 ∧ Agent e2 x"

theorem hypothesis:
  (* Premise: An old man sells hardware parts on a dirty sidewalk. *)
  assumes asm: "Old x ∧ Man x ∧ HardwareParts y ∧ DirtySidewalk z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ On e z"
  (* Hypothesis: The man is outside. *)
  shows "∃x e. Man x ∧ Outside e ∧ Is e ∧ Agent e x"
proof -
  from asm have "Man x ∧ DirtySidewalk z ∧ On e z ∧ Agent e x ∧ Patient e y" by blast
  then have "Outside e' ∧ Is e' ∧ Agent e' x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
