import json
import torch
import random
import math
import sys
import os

from typing import Optional
from grader import grade_answer

correct = 0

full_path = ""
with open(full_path, "r") as f:
    eval_rst = json.load(f)

for entry in eval_rst:
    ans_dict = {}
    correct_ans = str(entry['answer'])
    candidates = entry['candidates']

    for candidate in candidates:
        ans = candidate['answer']
        cur_score = candidate['step_scores'][-1]
        if ans not in ans_dict:
            ans_dict[ans] = cur_score
        else:
            ans_dict[ans] = max(cur_score, ans_dict[ans])

    sorted_answer_dict = sorted(ans_dict.items(), key=lambda p: p[1], reverse=True)
    output = sorted_answer_dict[0][0]
    correct += grade_answer(output, correct_ans)

accuracy = correct / len(eval_rst)
print(accuracy)

