import argparse
import logging
from src.pipeline import proposed_evaluation, official_conll_evaluation
from src.utils import format_dataframe

LOGGING_FORMAT = "%(asctime)s [%(levelname)8s] %(message)s (%(filename)s:%(lineno)s)"
logging.basicConfig(level=logging.INFO, format=LOGGING_FORMAT)
logger = logging.getLogger(__name__)

################################################################################
################################################################################


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Evaluate two given CoNNL-U+SRL files.')
    parser.add_argument('-g', '--gold-conllu', type=str, default="data/conll09.brown.test.conllu", help='File path of CoNLL-U with gold SRL.')
    parser.add_argument('-p', '--pred-conllu', type=str, default="data/conll09.brown.pred.roberta-base.conllu", help='File path of CoNNL-U with predicted SRL.')
    parser.add_argument('-o', '--output-folder', type=str, default="tmp", help='Output folder for files.')
    args = parser.parse_args()

    gold_conllu_fp = args.gold_conllu
    pred_conllu_fp = args.pred_conllu
    output_folder = args.output_folder

    cols = ['Metric', 'Type', 'Precision', 'Recall', 'F1']

    df_c = official_conll_evaluation(gold_conllu_fp, pred_conllu_fp, output_folder)
    df_p = proposed_evaluation(gold_conllu_fp, pred_conllu_fp, output_folder)

    print("*" * 80)
    print("Official CoNLL (2005 and 2009) evaluation:")
    print(format_dataframe(df_c[cols]))
    print("*" * 80)

    print("*" * 80)
    print("Proposed evaluation:")
    print(format_dataframe(df_p[cols]))
    print("*" * 80)
