# Model directory log
# models/siqa-4opts-rpberta-large : SIQA with 4th option generated from GPT
# models/oracle : Oracle experiment with gPT options
# models/siqa-atomic-qap-0.5-ep1-roberta-large: Ranked and filtered at 0.5 threshold, epochs=1
# models/siqa-atomic-qap-0.5-ep2-roberta-large: Ranked and filtered at 0.5 threshold, epochs=2, best = 77.43
# models/siqa-atomic-qap-0.1-0.5-kldiv-1.0-roberta-large: KL-Divergence cutoff at 1.0; QAP <= 0.5 and >= 0.1 (ATOMIC 100K) [Train file: train-with-atomic-filtered-v1.jsonl]
# models/atomic-593k-filtered-roberta-large; KL-Divergence cutoff at 1.0; QAP <= 0.5 and >= 0.1 (ATOMIC 593K) [Train file: atomic-train-gpt-c-filtered-593k.jsonl] [LR = 4e-6, BS=8] ; ::/siqa/ - finetuned on siqa; dev = 78.24 (best); baseline = 77.5
# models/atomic-593k-roberta-large;

#       --model_name_or_path ../out/atomic-roberta-large-cl/best-siqa-3e-6-bayes-0.61-1.14-636/checkpoint-9500/ \


#export SIQA_DIR=../data/siqa/
#python ./run_multiple_choice.py \
#       --model_type roberta \
#       --task_name siqa \
#       --model_name_or_path ./models/siqa-atomic-gpt-roberta-large/ \
#       --do_eval \
#       --train_file train.jsonl \
#       --eval_file dev.jsonl \
#       --data_dir $SIQA_DIR \
#       --learning_rate 4e-6 \
#       --num_train_epochs 1 \
#       --max_seq_length 128 \
#       --output_dir ./models/siqa-roberta-large/ \
#       --per_gpu_eval_batch_size=16 \
#       --per_gpu_train_batch_size=2 \
#       --gradient_accumulation_steps 2 \
#       --overwrite_output \
#       --save_steps 1000 \
#       --overwrite_cache
if [ "$1" = "train" ]; then
  export COSMOS_DIR=../../data/cosmosqa/
  python ./run_multiple_choice.py \
         --model_type roberta \
         --task_name cosmosqa \
         --model_name_or_path roberta-large \
         --do_train \
         --do_eval \
         --train_file train.jsonl \
         --eval_file dev.jsonl \
         --data_dir $SIQA_DIR \
         --learning_rate 5e-6 \
         --num_train_epochs 3 \
         --max_seq_length 128 \
         --output_dir ./baselines/siqa-roberta-large/ \
         --per_gpu_eval_batch_size=16 \
         --per_gpu_train_batch_size=2 \
         --gradient_accumulation_steps 4 \
         --eval_all_checkpoints \
         --overwrite_output \
         --save_steps 1000 \
        --logits_file logits.txt \
        --save_end_of_epoch

elif [ "$1" = "eval_valid" ]; then
  export COSMOSQA_DIR=../../data/cosmosqa/
  python ./run_multiple_choice.py \
         --model_type roberta \
         --task_name cosmosqa \
         --model_name_or_path ./baselines/cosmosqa-roberta-large/bayes-5e-6-4-8/checkpoint-12000/ \
         --do_eval \
         --train_file train.jsonl \
         --eval_file valid.jsonl \
         --data_dir $COSMOSQA_DIR \
         --learning_rate 5e-6 \
         --num_train_epochs 3 \
         --max_seq_length 128 \
         --output_dir ./baselines/cosmosqa-roberta-large/bayes-5e-6-4-8/checkopint-12000/ \
         --per_gpu_eval_batch_size=16 \
         --per_gpu_train_batch_size=2 \
         --gradient_accumulation_steps 4 \
         --eval_all_checkpoints \
         --save_steps 1000 \
        --logits_file logits.txt

elif [ "$1" = "eval_test" ]; then
  export COSMOSQA_DIR=../../data/cosmosqa/
  python ./run_multiple_choice.py \
         --model_type roberta \
         --task_name cosmosqa \
         --model_name_or_path ./baselines/cosmosqa-roberta-large/bayes-5e-6-4-8/checkpoint-12000/ \
         --do_test \
         --train_file train.jsonl \
         --eval_file test.jsonl \
         --data_dir $COSMOSQA_DIR \
         --learning_rate 5e-6 \
         --num_train_epochs 3 \
         --max_seq_length 128 \
         --output_dir ./baselines/cosmosqa-roberta-large/bayes-5e-6-4-8/checkpoint-12000/ \
         --per_gpu_eval_batch_size=16 \
         --per_gpu_train_batch_size=2 \
         --gradient_accumulation_steps 4 \
         --eval_all_checkpoints \
         --save_steps 1000 \
        --logits_file logits.txt
fi

#export SIQA_DIR=../data/siqa/
#python ./run_multiple_choice.py \
#       --model_type roberta \
#       --task_name siqa \
#       --model_name_or_path ./models/atomic-roberta-large/100k/ \
#       --do_train \
#       --do_eval \
#       --train_file train.jsonl \
#       --eval_file dev.jsonl \
#       --data_dir $SIQA_DIR \
#       --learning_rate 3e-6 \
#       --num_train_epochs 3 \
#       --max_seq_length 70 \
#       --output_dir  ./models/atomic-roberta-large/100k/siqa/ \
#       --per_gpu_eval_batch_size=16 \
#       --per_gpu_train_batch_size=4 \
#       --gradient_accumulation_steps 2 \
#       --eval_all_checkpoints \
#       --overwrite_output \
#       --save_steps 1000 \
#       --warmup_steps 360

#export SIQA_DIR=../data/siqa/
#python ./run_multiple_choice.py \
#       --model_type roberta \
#       --task_name siqa \
#       --model_name_or_path ./models/siqa-atomic-qap-0.5-ep2-roberta-large/ \
#       --do_train \
#       --do_eval \
#       --data_dir $SIQA_DIR \
#       --warmup_steps 500 \
#       --learning_rate 5e-6 \
#       --num_train_epochs 3 \
#       --max_seq_length 128 \
#       --output_dir ./models/siqa-atomic-qap-0.5-ep2-roberta-large/siqa-finetuned/ \
#       --per_gpu_eval_batch_size=2 \
#       --per_gpu_train_batch_size=2 \
#       --gradient_accumulation_steps 2 \
#       --overwrite_output \
#       --save_steps 1000 \
#       --eval_all_checkpoints
