from typing import List, Dict, Any, Optional
from collections import defaultdict
import math


class TfIdf(object):
    def __init__(self) -> None:
        pass

    @staticmethod
    def count_tf(document: List, TFtype: Optional[str] = None) -> Dict:
        tf = {}
        for term in document:
            if term not in tf:
                tf[term] = 0.0
            tf[term] += 1
    
        if type is not None:
            for term in tf:
                if TFtype == 'bool':
                    tf[term] = 0.0 if ft[term] == 0 else 1.0
                elif TFtype == '':
                    tf[term] = 1 + math.log(tf[term])
                else:
                    raise ValueError(f"Current type is {TFtype}, please choose right type.")
        
        return tf
    
    @staticmethod
    def conut_tfs(documents: List[List], TFtype: Optional[str] = None) -> List[Dict]:
        tfs = []
        for document in documents:
            tfs.append(TfIdf.count_tf(document, TFtype))
        
        return tfs

    @staticmethod
    def count_idf(document_vocabs: List[List], smooth: bool = True, add_one: bool = True) -> Dict:
        df, idf = {}, {}
        d, a = int(smooth), int(add_one)
        n = d

        for document_vocab in document_vocabs:
            n += 1
            for term in document_vocab:
                if term not in df:
                    df[term] = d
                df[term] += 1

        for term, freq in df.items():
            idf[term] = math.log(n / freq) + a
        
        return idf
    
    @staticmethod
    def get_tfidf(tf: Dict, idf: Dict, normalization: bool = False) -> Dict:
        tfIdf = {}

        for term, freq in tf.items():
            term_freq = max(1.0, freq)
            term_idf = idf[term] if term in idf else 1.0

            tfIdf[term] = term_freq * term_idf
        
        if normalization is True:
            n = 0.0
            for x in tfIdf.values():
                n += x * x
            n = math.sqrt(n)

            for term in tfIdf:
                tfIdf[term] = tfIdf[term] / n

        return tfIdf

    @staticmethod
    def idf_from_tfs(tfs: List[Dict], smooth: bool = True, add_one: bool = True) -> Dict:
        documents = []
        for document in fts:
            tmp = []
            for term, freq in document:
                tmp += [term] * freq
            documents.append(tmp)

        return TfIdf.count_idf(documents, smooth, add_one)
