#!/bin/bash

if [ $# -ne 4 ]; then
    echo "usage: $0 TESTSET SRCLANG TGTLANG GEN"
    exit 1
fi

TESTSET=$1
SRCLANG=$2
TGTLANG=$3

GEN=$4

if ! command -v sacremoses &> /dev/null
then
    echo "sacremoses could not be found, please install with: pip install sacremoses"
    exit
fi
if [ $SRCLANG = "zh" ] && [ $TGTLANG = "en" ]; then 
    grep ^H $GEN \
    | sed 's/^H\-//' \
    | sort -n -k 1 \
    | cut -f3 \
    | perl ../../../multdomain/fairseq-v4-old/examples/translation/mosesdecoder/scripts/recaser/detruecase.perl \
    | sacremoses -l $TGTLANG detokenize \
    > $GEN.sorted.detok
else
    grep ^H $GEN \
    | sed 's/^H\-//' \
    | sort -n -k 1 \
    | cut -f 3 \
    | sacremoses -l $TGTLANG detokenize \
    > $GEN.sorted.detok
fi
sacrebleu --test-set $TESTSET --language-pair "${SRCLANG}-${TGTLANG}" < $GEN.sorted.detok
