from sympy import Eq

""" Operator tokens """
#: LIST OF OPERATOR TOKEN STRINGS
OPR_TOKENS = ['__NEW_EQN', '__NEW_VAR', '__DONE', '=', '+', '-', '*', '/', '^']
#: NUMBER OF OPERATOR TOKENS
OPR_SZ = len(OPR_TOKENS)

""" Special operator ids """
OPR_NEW_EQN_ID = 0  #: POSITION OF NEW EQUATION FUNCTION
OPR_NEW_VAR_ID = OPR_NEW_EQN_ID + 1  #: POSITION OF NEW VARIABLE FUNCTION
OPR_DONE_ID = OPR_NEW_VAR_ID + 1  #: POSITION OF DONE FUNCTION
OPR_EQ_SGN_ID = OPR_DONE_ID + 1  #: POSITION OF '=' FUNCTION
OPR_PLUS_ID = OPR_TOKENS.index('+')  #: POSITION OF '+' FUNCTION
OPR_NEW_EQN = OPR_TOKENS[OPR_NEW_EQN_ID]  #: STRING TOKEN - NEW EQUATION
OPR_NEW_VAR = OPR_TOKENS[OPR_NEW_VAR_ID]  #: STRING TOKEN - NEW VAR
OPR_DONE = OPR_TOKENS[OPR_DONE_ID]  #: STRING TOKEN - DONE

OPR_SPECIAL = OPR_TOKENS[:OPR_EQ_SGN_ID]  #: LIST OF SPECIAL FUNCTIONS
OPR_NON_SPECIAL = OPR_TOKENS[OPR_EQ_SGN_ID:]  #: LIST OF MATHEMATICAL FUNCTIONS

""" Operator information """
KEY_ARITY = 'arity'  #: STRING KEY FOR ARITY VALUE
KEY_CONVERT = 'convert'  #: STRING KEY FOR CONVERTER FUNCTION
KEY_COMMUTATIVE = 'commutative'  #: STRING KEY FOR COMMUTATIVE PROPERTY
KEY_TOPLV = 'top_level'  #: STRING KEY FOR INDICATOR OF TOP-LEVEL NODE IN EACH EQUATION TREE
KEY_PRECEDENCE = 'precedence'  #: STRING KEY FOR PRECEDENCE - INFIX PARSER
OPR_VALUES = [
    # NEW_EQN()
    {KEY_ARITY: 0, KEY_COMMUTATIVE: True, KEY_TOPLV: False, KEY_CONVERT: None, KEY_PRECEDENCE: None},
    # NEW_VAR()
    {KEY_ARITY: 0, KEY_COMMUTATIVE: True, KEY_TOPLV: False, KEY_CONVERT: None, KEY_PRECEDENCE: None},
    # DONE()
    {KEY_ARITY: 0, KEY_COMMUTATIVE: True, KEY_TOPLV: False, KEY_CONVERT: None, KEY_PRECEDENCE: None},
    # = binary
    {KEY_ARITY: 2, KEY_COMMUTATIVE: True, KEY_TOPLV: True, KEY_CONVERT: (lambda *x: Eq(x[0], x[1], evaluate=False)),
     KEY_PRECEDENCE: 1},
    # + binary
    {KEY_ARITY: 2, KEY_COMMUTATIVE: True, KEY_TOPLV: False, KEY_CONVERT: (lambda *x: x[0] + x[1]),
     KEY_PRECEDENCE: 2},
    # - binary
    {KEY_ARITY: 2, KEY_COMMUTATIVE: False, KEY_TOPLV: False, KEY_CONVERT: (lambda *x: x[0] - x[1]),
     KEY_PRECEDENCE: 2},
    # * binary
    {KEY_ARITY: 2, KEY_COMMUTATIVE: True, KEY_TOPLV: False, KEY_CONVERT: (lambda *x: x[0] * x[1]),
     KEY_PRECEDENCE: 3},
    # / binary
    {KEY_ARITY: 2, KEY_COMMUTATIVE: False, KEY_TOPLV: False, KEY_CONVERT: (lambda *x: x[0] / x[1]),
     KEY_PRECEDENCE: 3},
    # ^ binary
    {KEY_ARITY: 2, KEY_COMMUTATIVE: False, KEY_TOPLV: False, KEY_CONVERT: (lambda *x: x[0] ** x[1]),
     KEY_PRECEDENCE: 4}
]
assert OPR_SZ == len(OPR_VALUES)

#: MAXIMUM ARITY VALUE OF AN OPERATOR
OPR_MAX_ARITY = max(op[KEY_ARITY] for op in OPR_VALUES)
#: LIST OF TOP-LEVEL NODE TYPES
OPR_TOP_LV = {i
              for i, token in enumerate(OPR_VALUES) if token[KEY_TOPLV]}
